function [ packages, remaining_samples, found_package] = find_packages_fast3(  ...
    samples_IN, package_samples_length, training_up, found_package)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here


packages = [];

samples_IN_length = length(samples_IN);

if samples_IN_length < package_samples_length
    remaining_samples = samples_IN';
    return;
end

% parameters working for .wav file
threshold = 0.5; %energy threshold
threshold_corr = 9.8; % cross correlation threshold
threshold_corr_factor = 7;
threshold_corr_factor_following = 4;
window_length = 40;

energy_in_window = 0.001;
threshold_factor = 10;
threshold_min = 0.01;


if found_package == 0
    ii_stop = samples_IN_length-window_length+1;
    ii = 1;
    while ii<ii_stop
        noise_energy = energy_in_window;
        energy_in_window = sum(samples_IN(ii:ii+window_length-1).^2);
        
%          if energy_in_window > 0.01
%             energy_in_window 
%          end

        % check is the energy in the window is above a certain threshold
        if (energy_in_window > (threshold_factor * (noise_energy+threshold_min)))
            
            % if there are not enough samples for a whole package, return
            if (samples_IN_length-ii-window_length+1 < package_samples_length)
                remaining_samples = samples_IN(max(ii-1,1):end)';
                return;
            end

            % otherwise calculate cross correlation
            t_start = max(1,ii-window_length-1);
            t_end = min(ii+window_length-1, length(samples_IN)-length(training_up));
            % Try all time shifts between t_start and t_end
            xcor_signal_training = zeros(1,t_end-t_start+1);
            for t_tmp = t_start:t_end
                % Save result for this particular t_tmp in array
                xcor_signal_training(t_tmp-t_start+1) = ...
                abs(training_up*samples_IN(t_tmp:t_tmp+length(training_up)-1));  
            end

            maximum_corr = max(xcor_signal_training);
            
             %maximum_corr > threshold_corr && ...
            if  maximum_corr > threshold_corr_factor * abs(mean(xcor_signal_training))     
                
                max_index = find(xcor_signal_training == maximum_corr);
            
                max_index = max_index + t_start -1;

                packages = [packages; samples_IN(max_index:...
                        max_index+package_samples_length-1)'];
                found_package = found_package + 1;

                remaining_samples = samples_IN(max_index+package_samples_length:end)';
                ii = max_index+package_samples_length;
                %continue;
                return;
            end
        end
        energy_in_window = noise_energy;
        ii = ii+window_length;
    end
    
% if is not first package    
else
    found_package = 0;
    % otherwise calculate cross correlation
    t_start = 1;
    t_end = 30;
    % Try all time shifts between t_start and t_end
    xcor_signal_training = zeros(1,t_end-t_start+1);
    for t_tmp = t_start:t_end
        % Save result for this particular t_tmp in array
        xcor_signal_training(t_tmp-t_start+1) = ...
        abs(training_up*samples_IN(t_tmp:t_tmp+length(training_up)-1));  
    end

    maximum_corr = max(xcor_signal_training);
    
    %if maximum_corr > threshold_corr %&& ...
    if maximum_corr > threshold_corr_factor_following * abs(mean(xcor_signal_training))  
        max_index = find(xcor_signal_training == maximum_corr);
        
        if (samples_IN_length-max_index < package_samples_length)
              remaining_samples = samples_IN(max_index:end)';
              return;
        end
        
        max_index = max_index + t_start -1;
        
        packages = [packages; samples_IN(max_index:...
                max_index+package_samples_length-1)'];
        found_package = found_package + 1;

        remaining_samples = samples_IN(max_index+package_samples_length:end)';
        return;
    end
end

if found_package == 0
   remaining_samples = samples_IN(max(1,end-package_samples_length-1):end)';
    
    
    % When we use 8-PSK there is some problem with the remaining samples,
    % commenting the above line and adding the following line fixes the
    % problem
    
  %remaining_samples = [];
end

end

